<?php

/**
 * @author ZiniPay <info@zinipay.com>
 *
 * @contributor Abu Sayed Al Siam <[info@zinipay.com]>
 *
 * @created 28-11-2025
 */

namespace Modules\ZiniPay\Views;

use Modules\Gateway\Contracts\PaymentViewInterface;
use Modules\Gateway\Services\GatewayHelper;
use Modules\Gateway\Traits\ApiResponse;
use Modules\ZiniPay\Entities\ZiniPay;

class ZiniPayView implements PaymentViewInterface
{
    use ApiResponse;

    public static function paymentView($key)
    {
        $helper = GatewayHelper::getInstance();

        try {
            $ziniPay = ZiniPay::firstWhere('alias', 'zinipay')->data;

            return view('zinipay::pay', [
                'apiKey' => $ziniPay->apiKey,
                'instruction' => $ziniPay->instruction,
                'purchaseData' => $helper->getPurchaseData($key),
            ]);
        } catch (\Exception $e) {
            return back()->withErrors(['error' => __('Purchase data not found.')]);
        }
    }

    public static function paymentResponse($key)
    {
        $helper = GatewayHelper::getInstance();

        $ziniPay = ZiniPay::firstWhere('alias', 'zinipay')->data;

        return [
            'apiKey' => $ziniPay->apiKey,
            'instruction' => $ziniPay->instruction,
            'purchaseData' => $helper->getPurchaseData($key),
        ];
    }
}
