<?php

/**
 * @author ZiniPay <info@zinipay.com>
 *
 * @contributor Abu Sayed Al Siam <[info@zinipay.com]>
 *
 * @created 28-11-2025
 */

namespace Modules\ZiniPay\Response;

use Modules\Gateway\Contracts\HasDataResponseInterface;
use Modules\Gateway\Response\Response;

class ZiniPayResponse extends Response implements HasDataResponseInterface
{
    protected $response;

    private $data;

    public function __construct($data, $ziniPayResponse)
    {
        $this->data = $data;
        $this->response = $ziniPayResponse;
        $this->updateStatus();

        return $this;
    }

    public function getRawResponse(): string
    {
        return json_encode($this->response);
    }

    protected function updateStatus()
    {
        if ($this->response->status == 'COMPLETED') {
            $this->setPaymentStatus('completed');
        } else {
            $this->setPaymentStatus('failed');
        }
    }

    public function getResponse(): string
    {
        return json_encode($this->getSimpleResponse());
    }

    private function getSimpleResponse()
    {
        return [
            'amount' => $this->response->amount,
            'amount_captured' => $this->response->charged_amount,
            'currency' => $this->data->currency_code,
            'code' => $this->data->code,
            'payment_method' => $this->response->payment_method,
            'sender_number' => $this->response->sender_number,
            'transaction_id' => $this->response->transaction_id,
            'invoice_id' => $this->response->invoice_id,
        ];
    }

    public function getGateway(): string
    {
        return 'ZiniPay';
    }

    protected function setPaymentStatus($status)
    {
        $this->status = $status;
    }
}
