<?php

namespace Modules\ZiniPay\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Addons\Entities\Addon;
use Modules\ZiniPay\Entities\ZiniPay;
use Modules\ZiniPay\Entities\ZiniPayBody;
use Modules\ZiniPay\Http\Requests\ZiniPayRequest;

class ZiniPayController extends Controller
{

    /**
     * Store a newly created resource in storage.
     *
     *
     * @return mixed
     */
    public function store(ZiniPayRequest $request)
    {
        $ziniPayBody = new ZiniPayBody($request);

        ZiniPay::updateOrCreate(
            ['alias' => 'zinipay'],
            [
                'name' => 'ZiniPay',
                'instruction' => $request->instruction,
                'status' => $request->status,
                'baseUrl' => $request->baseUrl,
                'image' => 'thumbnail.png',
                'data' => json_encode($ziniPayBody),
            ]
        );

        return back()->with(['AddonStatus' => 'success', 'AddonMessage' => __('ZiniPay settings updated.')]);
    }

    /**
     * Returns form for the edit modal
     *
     * @param \Illuminate\Http\Request
     * @return JsonResponse
     */
    public function edit(Request $request)
    {
        try {
            $module = ZiniPay::first()->data;
        } catch (\Exception $e) {
            $module = null;
        }
        $addon = Addon::findOrFail('ZiniPay');

        return response()->json(
            [
                'html' => view('gateway::partial.form', compact('module', 'addon'))->render(),
                'status' => true,
            ],
            200
        );
    }

}
