<?php

return [
    'name' => 'ZiniPay',

    'alias' => 'zinipay',

    'logo' => 'Modules/ZiniPay/Resources/assets/logo.png',

    // Zinipay addon settings

    'options' => [
        ['label' => __('Settings'), 'type' => 'modal', 'url' => 'zinipay.edit'],
        ['label' => __('ZiniPay Documentation'), 'target' => '_blank', 'url' => 'https://zinipay.com/docs'],
    ],

    /**
     * Uddokatapay data validation
     */
    'validation' => [
        'rules' => [
            'apiKey' => 'required',
            'baseUrl' => 'required',
        ],
        'attributes' => [
            'apiKey' => __('API Key'),
            'baseUrl' => __('Base Url'),
        ],
    ],
    'fields' => [
        'apiKey' => [
            'label' => __('API Key'),
            'type' => 'text',
            'required' => true,
        ],
        'instruction' => [
            'label' => __('Instruction'),
            'type' => 'textarea',
        ],
        'baseUrl' => [
            'label' => __('Base Url'),
            'type' => 'text',
            'required' => true,
        ],
        'status' => [
            'label' => __('Status'),
            'type' => 'select',
            'required' => true,
            'options' => [
                'Active' => 1,
                'Inactive' =>  0,
            ],
        ],
    ],

    'store_route' => 'zinipay.store',

];

