<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ZiniPay Payment</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        *{
            font-family: 'Nunito', sans-serif;
        }
        h1{
            font-weight: 700;
            color: #4A3BDD;
            font-size: 42px;
        }
        .pay-box{
            background: #ffffff;
            padding: 25px;
            border-radius: 10px;
            border: 1px solid #eee;
        }
        .footer-text{
            margin-top: 35px;
            font-size: 13px;
            text-align: center;
            color: #777;
        }
    </style>
</head>

<body>
    <div class="container mt-5">
        <div class="row">
            <div class="col-6 offset-3">

                <div class="pay-box">
                    <h1 class="text-center">ZiniPay Checkout</h1>

                    @if ($errors->any())
                        <div class="alert alert-danger mt-3">
                            <ul class="m-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif


                    <form action="{{ route('zinipay.pay') }}" class="mt-4" method="POST">
                        @csrf

                        <label for="name" class="mt-2"><b>Full Name</b></label>
                        <input name="full_name" type="text" id="name" class="form-control mt-1" value="Code Ecstasy">

                        <label for="email" class="mt-4"><b>Email Address</b></label>
                        <input name="email" type="email" id="email" class="form-control mt-1" value="email@example.com">

                        <label for="amount" class="mt-4"><b>Amount (BDT)</b></label>
                        <input name="amount" type="number" id="amount" class="form-control mt-1" value="50">

                        <button type="submit" class="btn btn-primary w-100 mt-4">
                            Pay Now
                        </button>
                    </form>

                    <p class="footer-text">
                        © {{ date('Y') }} ZiniPay — Simple & Secure Payments
                    </p>
                </div>

            </div>
        </div>
    </div>
</body>
</html>
