# ZiniPay Payment Gateway Integration

ZiniPay is a simple and secure payment gateway that allows you to receive payments directly to your personal mobile wallet. This guide shows how you can quickly integrate the ZiniPay payment system into a Laravel application.

## Installation & Setup

We will use the **sandbox environment** for testing.  
Developer documentation: **https://developer.zinipay.com**

### **1. Copy the library files**

Place the entire `library` folder inside your Laravel `app` directory.

### **2. Add the controller**

Copy `ZinipayController.php` and place it inside:

```
app/Http/Controllers
```

### **3. Add the routes (web.php)**

Add these routes to your `routes/web.php` file:

```php
Route::get('pay', [ZinipayController::class, 'show'])->name('zinipay.payment-form');
Route::post('pay', [ZinipayController::class, 'pay'])->name('zinipay.pay');
Route::get('success', [ZinipayController::class, 'success'])->name('zinipay.success');
Route::get('cancel', [ZinipayController::class, 'cancel'])->name('zinipay.cancel');
```

### **4. Add webhook route (api.php)**

Place this route inside `routes/api.php`:

```php
Route::post('webhook', [ZinipayController::class, 'webhook'])->name('zinipay.webhook');
```

### **5. Add the payment form view**

Copy `payment-form.blade.php` into:

```
resources/views/zinipay
```

### **6. Set your API key**

Add your ZiniPay API key to your `.env` file:

```env
ZINIPAY_API_KEY=YOUR_API_KEY_HERE
```

## 🎉 That's it!

Your Laravel project is now ready to use the ZiniPay payment gateway in sandbox mode.  
You can test the full payment workflow, callback response, and webhook handling easily.
